from django import template

register = template.Library()

@register.filter
def get_chart_color(index):
    """Return a Bootstrap color class based on the index."""
    colors = [
        'primary',   # Blue
        'success',   # Green
        'info',      # Cyan
        'warning',   # Yellow
        'danger',    # Red
        'secondary', # Gray
        'dark',      # Dark gray
    ]
    return colors[(index - 1) % len(colors)]
